/*
 * Decompiled with CFR 0.152.
 */
package de.dustplanet.passwordprotect;

import de.dustplanet.passwordprotect.jail.JailHelper;
import de.dustplanet.passwordprotect.listeners.PasswordProtectBlockListener;
import de.dustplanet.passwordprotect.listeners.PasswordProtectEntityListener;
import de.dustplanet.passwordprotect.listeners.PasswordProtectPlayerListener;
import de.dustplanet.passwordprotect.util.stats.bukkit.Metrics;
import de.dustplanet.passwordprotect.utils.PasswordProtectUtilities;
import de.dustplanet.passwordprotect.utils.ScalarYamlConfiguration;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.UUID;
import java.util.logging.Level;
import net.gravitydevelopment.updater.Updater;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffectType;

@SuppressFBWarnings(value={"IMC_IMMATURE_CLASS_NO_TOSTRING", "FCCD_FIND_CLASS_CIRCULAR_DEPENDENCY", "CD_CIRCULAR_DEPENDENCY"})
public class PasswordProtect
extends JavaPlugin {
    private static final int BSTATS_PLUGIN_ID = 2038;
    private static final int PLUGIN_ID = 39561;
    private JailHelper jailHelper;
    private FileConfiguration localization;
    private File jailedPlayersFile;
    private final PasswordProtectUtilities utils = new PasswordProtectUtilities(this);

    @SuppressFBWarnings(value={"NP_UNWRITTEN_FIELD", "UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"})
    public void onDisable() {
        for (UUID playerUUID : this.jailHelper.getJailedPlayers().keySet()) {
            Player player = this.getServer().getPlayer(playerUUID);
            if (player == null) continue;
            if (player.hasPotionEffect(PotionEffectType.BLINDNESS)) {
                player.removePotionEffect(PotionEffectType.BLINDNESS);
            }
            if (!player.hasPotionEffect(PotionEffectType.SLOW)) continue;
            player.removePotionEffect(PotionEffectType.SLOW);
        }
        try (ObjectOutputStream obj = new ObjectOutputStream(Files.newOutputStream(this.jailedPlayersFile.toPath(), new OpenOption[0]));){
            obj.writeObject(this.jailHelper.getJailedPlayers());
        }
        catch (IOException e) {
            this.getLogger().log(Level.INFO, "Couldn't find the 'jailedPlayers.dat' file!", e);
        }
        this.jailHelper.clear();
        this.utils.getCommandList().clear();
    }

    public void onEnable() {
        File jailFile = new File(this.getDataFolder(), "jails.yml");
        if (!jailFile.exists()) {
            this.utils.copy("jails.yml", jailFile);
        }
        ScalarYamlConfiguration jails = ScalarYamlConfiguration.loadConfiguration(jailFile);
        PluginManager pluginManager = this.getServer().getPluginManager();
        this.jailHelper = new JailHelper(this, jailFile, (FileConfiguration)jails);
        pluginManager.registerEvents((Listener)new PasswordProtectBlockListener(this, this.jailHelper), (Plugin)this);
        pluginManager.registerEvents((Listener)new PasswordProtectPlayerListener(this, this.jailHelper), (Plugin)this);
        pluginManager.registerEvents((Listener)new PasswordProtectEntityListener(this, this.jailHelper), (Plugin)this);
        if (!this.getDataFolder().exists() && !this.getDataFolder().mkdirs()) {
            this.getLogger().severe("The config folder could NOT be created, make sure it's writable!");
            this.getLogger().severe("Disabling now!");
            this.setEnabled(false);
            return;
        }
        File configFile = new File(this.getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            this.utils.copy("config.yml", configFile);
        }
        this.utils.loadConfig();
        File localizationFile = new File(this.getDataFolder(), "localization.yml");
        if (!localizationFile.exists()) {
            this.utils.copy("localization.yml", localizationFile);
        }
        this.setLocalization((FileConfiguration)ScalarYamlConfiguration.loadConfiguration(localizationFile));
        this.utils.loadLocalization(this.getLocalization(), localizationFile);
        this.loadJailedPlayers();
        this.utils.registerCommands(this.jailHelper);
        this.checkForUpdate();
        this.registerMetrics();
    }

    @SuppressFBWarnings(value={"OBJECT_DESERIALIZATION"})
    private void loadJailedPlayers() {
        this.jailedPlayersFile = new File(this.getDataFolder(), "jailedPlayers.dat");
        if (this.jailedPlayersFile.exists()) {
            try (ObjectInputStream obj = new ObjectInputStream(Files.newInputStream(this.jailedPlayersFile.toPath(), new OpenOption[0]));){
                this.jailHelper.setJailedPlayers((HashMap)obj.readObject());
            }
            catch (IOException | ClassNotFoundException e) {
                this.getLogger().log(Level.INFO, "Couldn't read the 'jailedPlayers.dat' file!", e);
            }
        } else {
            try {
                if (!this.jailedPlayersFile.createNewFile()) {
                    this.getLogger().info("Creating the 'jailedPlayers.dat' file failed!");
                }
            }
            catch (IOException e) {
                this.getLogger().log(Level.INFO, "Couldn't create the 'jailedPlayers.dat' file!", e);
            }
        }
    }

    @SuppressFBWarnings(value={"SEC_SIDE_EFFECT_CONSTRUCTOR"})
    private void registerMetrics() {
        new Metrics(this, 2038);
    }

    private void checkForUpdate() {
        if (this.getConfig().getBoolean("autoUpdater", true)) {
            if (this.getDescription().getVersion().contains("SNAPSHOT")) {
                this.getLogger().info("AutoUpdater is disabled because you are running a dev build!");
            } else {
                try {
                    new Updater((Plugin)this, 39561, this.getFile(), Updater.UpdateType.DEFAULT, updaterResult -> this.getLogger().log(Level.INFO, "Result from AutoUpdater is: {0}", (Object)updaterResult.getResult()), true);
                    this.getLogger().info("AutoUpdater is enabled and now running.");
                }
                catch (Exception e) {
                    this.getLogger().log(Level.INFO, "Error while auto updating:", e);
                }
            }
        } else {
            this.getLogger().info("AutoUpdater is disabled due to config setting.");
        }
    }

    public FileConfiguration getLocalization() {
        return this.localization;
    }

    public void setLocalization(FileConfiguration localization) {
        this.localization = localization;
    }

    public PasswordProtectUtilities getUtils() {
        return this.utils;
    }
}

